<?php
namespace App\Imports;

use App\Models\SparePart;
use App\Models\Vendor;
use App\Models\CarModel;
use App\Models\Category;
use App\Models\City;
use App\Models\Brand;
use Maatwebsite\Excel\Row;
use Maatwebsite\Excel\Concerns\OnEachRow;
use Maatwebsite\Excel\Concerns\WithHeadingRow;

class SparePartsImport implements OnEachRow, WithHeadingRow
{
    public function onRow(Row $row)
    {
        $row = $row->toArray();

        if (empty($row['name']) || empty($row['price'])) {
            return; // Skip invalid rows
        }

        $vendor = Vendor::where('name->ar', $row['vendor'])->first();
        $model = CarModel::where('name->ar', $row['model'])->first();
        $category = Category::where('name->ar', $row['category'])->first();
        $city = City::where('name->ar', $row['city'])->first();
        $brand = Brand::where('name->ar', $row['brand'])->first();

        SparePart::create([
            'name'             => $row['name'],
            'description'      => $row['description'],
            'price'            => $row['price'],
            'vendor_id'        => $vendor?->id,
            'model_id'         => $model?->id,
            'category_id'      => $category?->id,
            'city_id'          => $city?->id,
            'brand_id'         => $brand?->id,
            'stock'            => $row['stock'] ?? 0,
            'warranty_period'  => $row['warranty_period'] ?? null,
            'is_new'           => $row['is_new'] === 'نعم' ? 1 : 0,
            'is_active'        => $row['is_active'] === 'نعم' ? 1 : 0,
        ]);
    }
}
